<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class CreateRestApiController extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:api-controller {name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create api controller';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $name = $this->argument('name');

        $name = ucfirst($name);

        Artisan::call("make:controller RestApi/V1/{$name}Controller");

        $this->info("controller Request created successfully!");
    }
}
