<?php

namespace App\Http\Controllers;

use App\Enums\NotificationEnum;
use App\Models\Student;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;

abstract class Controller
{
    public function redirectWithNotification(\Illuminate\Http\RedirectResponse $redirectResponse, ?string $message = null, string|NotificationEnum $status = null)
    {
        if($status===NotificationEnum::SUCCESS){
            Alert::success('success',$message);
        }
        if($status===NotificationEnum::ERROR){
            Alert::error('error',$message);
        }
        if($status===NotificationEnum::INFO){
            Alert::info('info',$message);
        }
        if($status===NotificationEnum::WARNING){
            Alert::warning('warning',$message);
        }
        return $redirectResponse
            ->with('status', $status ?? 'info')
            ->with('message', $message);
    }


}
