<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\CourseSection\CreateCourseSectionRequest;
use App\Http\Requests\CourseSection\UpdateCourseSectionRequest;
use Illuminate\Http\Request;

class CourseSectionController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateCourseSectionRequest $request)
    {
        if($this->create($request)) {
            return $this->redirectWithNotification(
               back(), 'success', 'Course Section created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create course section');
    }

    public function updateOne(UpdateCourseSectionRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
                back(), 'success', 'Course Section updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update course section');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
                back(), 'success', 'Course Section deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete course section');
    }
}
