<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\ExamTask\CreateExamTaskRequest;
use App\Http\Requests\ExamTask\UpdateExamTaskRequest;
use Illuminate\Http\Request;

class ExamTaskController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateExamTaskRequest $request)
    {
        if($this->create($request)) {
            return $this->redirectWithNotification(
                back(), 'success', 'Exam task created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create exam task');
    }

    public function updateOne(UpdateExamTaskRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
                back(), 'success', 'Exam task updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update exam task');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
                back(), 'success', 'Exam task deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete exam task');
    }
}
