<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\Permission\CreatePermissionRequest;
use App\Http\Requests\Permission\UpdatePermissionRequest;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Http\Request;

class PermissionController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreatePermissionRequest $request)
    {
        if ($this->create($request, [
            'number' => $this->model::count() + 1,
            'is_active' => true,
        ])) {
            return $this->redirectWithNotification(
                redirect()->route('admin.permissions', ['id' => $request->material_id]),
                'success',
                'Permission created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create Permission');
    }

    public function updateOne(UpdatePermissionRequest $request, $id)
    {
        if ($this->update($request, $id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.permissions', ['id' => $request->material_id]),
                'success',
                'Permission updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update Permission');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->redirectWithNotification(
                back(),
                'success',
                'Permission deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete Permission');
    }

    public function assignRole($roleId, $permissionId)
    {
        $role = Role::findOrFail($roleId);
        $permission = Permission::findOrFail($permissionId);
        $permission->assignRole($role);

        return $this->redirectWithNotification(back(), 'role assigned','success');
    }
}
