<?php

namespace App\Http\Controllers\Core;


use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\StudentProcessCourse\CreateStudentProcessCourseRequest;
use App\Http\Requests\StudentProcessCourse\UpdateStudentProcessCourseRequest;
use Illuminate\Http\Request;

class StudentProcessCourseController extends CoreController
{

    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;


    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateStudentProcessCourseRequest $request)
    {
        if($this->create($request)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.studentProcessCourses'), 'success', 'StudentProcessCourse created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create studentProcessCourse');
    }


    public function updateOne(UpdateStudentProcessCourseRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.studentProcessCourses'), 'success', 'StudentProcessCourse updated successfully'
            );
        }
        return $this->redirectWithNotification(back(), 'error', 'Failed to update studentProcessCourse');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.studentProcessCourses'), 'success', 'StudentProcessCourse deleted successfully'
            );
        }
        return $this->redirectWithNotification(back(), 'error', 'Failed to delete studentProcessCourse');
    }
}
