<?php

namespace App\Http\Controllers\RestApi\V1;


use App\Enums\UserTypeEnum;
use App\Extensions\Controller\ModelGetExtension;
use App\Http\Controllers\RestApiController;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Requests\Admin\CreateAdminRequest;
use App\Http\Requests\Admin\UpdateAdminRequest;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


class AdminController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: ['user'])->get());
    }

    public function readOne($id)
    {
        return $this->successResponse($this->model::with(relations: ['user'])->findOrFail($id));
    }

    public function createOne(CreateAdminRequest $request)
    {

        $user = User::create([
            'name' => $request->name,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'phone' => $request->phone,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'api_token' => Str::random(20),
            'type' => UserTypeEnum::ADMIN
        ]);

        if ($user && $this->create($request, ['user_id' => $user->id])) {
            return $this->successResponse(
                [
                    'admin' => $this->modelCreated,
                    'user' => $user
                ],
                'Admin created successfully',
                201
            );
        }

        return $this->badRequestResponse('Failed to create Admin');
    }

    public function updateOne(UpdateAdminRequest $request, $id)
    {
        if ($this->update($request, $id)) {
            return $this->successResponse(
                $this->modelUpdated,
                'Admin updated successfully'
            );
        }

        return $this->badRequestResponse('Failed to update Admin');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->successResponse(
                null,
                'Admin deleted successfully'
            );
        }

        return $this->badRequestResponse('Failed to delete Admin');
    }
}
