<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\ModelGetExtension;
use App\Http\Controllers\RestApiController;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Requests\CourseNote\CreateCourseNoteRequest;
use App\Http\Requests\CourseNote\UpdateCourseNoteRequest;

class CourseNoteController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: ['course','courseSection'])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse($this->model::with(relations:['course','courseSection'])->findOrFail($id));
    }

    public function createOne(CreateCourseNoteRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'CourseNote created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create CourseNote');
    }

    public function updateOne(UpdateCourseNoteRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'CourseNote updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update CourseNote');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'CourseNote deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete CourseNote');
    }
}
