<?php

namespace App\Http\Middleware\RestApi;

use App\Enums\UserTypeEnum;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SuperAdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->user()->type === UserTypeEnum::SUPER_ADMIN) {
            return response()->json([
                'status' => 'error',
                'message' => 'only super-admin can access this API endpoint'
            ], 403);
        }
        return $next($request);
    }
}
