<?php

namespace App\Http\Middleware\View;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CustomAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        // Custom logic to check authentication
        if (!Auth::check()) {
            // Custom behavior, like redirecting to a custom page or handling unauthenticated users differently
            return redirect('/custom-login');
        }

        return $next($request);
    }
}
