<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class CreateAdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name'=>'required|string',
            'first_name'=>'required|string',
            'last_name'=>'required|string',
            'phone'=>'required|string|max:15',
            'email'=>'required|email',
            'password'=>'required|string|min:10',
            'batch'=>'required|string',
        ];
    }
}
