<?php

namespace App\Http\Requests\ExamTask;

use Illuminate\Foundation\Http\FormRequest;

class UpdateExamTaskRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'exam_id'=>'nullable|exists:exams,id',
            'question'=>'nullable|string',
            'choices'=>'nullable|array',
            'choices.*'=>'string',
            'answer'=>'nullable|string',
            'image'=>'nullable|string',
            'video_time'=>'nullable|string',
            'points'=>'nullable|integer',
        ];
    }
}
