<?php

namespace App\Http\Requests\Lecture;

use Illuminate\Foundation\Http\FormRequest;

class UpdateLectureRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'course_id' => 'nullable|integer',
            'course_section_id' => 'nullable|integer,exists:course_sections,id',
            'teacher_id' => 'nullable|integer,exists:teachers,id',
            'video_id' => 'nullable|integer,exists:videos,id',
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'time' => 'nullable|string',
            'number' => 'nullable|integer',
            'is_active' => 'nullable|boolean'
        ];
    }
}
