<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseNote extends Model
{
    /** @use HasFactory<\Database\Factories\CourseNoteFactory> */
    use HasFactory;

    protected $fillable = [
        'course_id',
        'course_section_id',
        'type',
        'content',
        'image',
    ];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }
    public function courseSection()
    {
        return $this->belongsTo(CourseSection::class);
    }
}
