<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExamTask extends Model
{
    /** @use HasFactory<\Database\Factories\ExamTaskFactory> */
    use HasFactory;

    protected $fillable = [
        'exam_id',
        'question',
        'choices',
        'answer',
        'image',
        'video_time',
        'points',
    ];

    protected function casts(): array
    {
        return [
            'exam_id' => 'integer',
            'choices' => 'array',  // Assuming 'choices' is a JSON field
            'video_time' => 'string', // Assuming 'video_time' stores time as a string
            'points' => 'integer',
        ];
    }

    public function exam()
    {
        return $this->belongsTo(Exam::class);
    }
}
