<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Level extends Model
{
    /** @use HasFactory<\Database\Factories\LevelFactory> */
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
    ];

    protected $casts = [
        'title' => 'string',
        'description' => 'string', // Nullable, so it's treated as a string if present
    ];

    public function subLevels()
    {
        return $this->hasMany(SubLevel::class);
    }

    public function materials()
    {
        return $this->hasMany(Material::class);
    }

    public function students()
    {
        return $this->hasMany(Student::class);
    }
}
