<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentExams extends Model
{
    /** @use HasFactory<\Database\Factories\StudentExamsFactory> */
    use HasFactory;

    protected $fillable = [
        'student_id',
        'exam_id',
        'grade',
    ];

    protected $casts = [
        'student_id' => 'integer',
        'exam_id' => 'integer',
        'grade' => 'integer',
    ];

    // Relationships
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function exam()
    {
        return $this->belongsTo(Exam::class);
    }
}
