<?php

namespace App\Services\Model;

use App\Models\Lecture;
use App\Models\LectureReview;

class LectureService
{
    public function __construct(
        protected ?Lecture $lecture,
        protected ?LectureReview $lectureReview
    ) {
        //
    }

    /**
     * Get review by videoId and studentId
     * @return LectureReview|null
     */
    public function getReview($lectureId, $studentId)
    {
        return LectureReview::with('lecture', 'student')
            ->where('lecture_id', $lectureId)
            ->where('student_id', $studentId)
            ->first(); // Get a single review for a specific student and lecture
    }


    /**
     * Like the video (create review)
     * @return bool
     */
    public function likeVideo($lectureId, $studentId): bool
    {
        $data = [
            'student_id' => $studentId,
            'lecture_id' => $lectureId,
        ];

        // Check if review exists
        $existingReview = $this->getReview($lectureId, $studentId);

        // If review doesn't exist, create a new one
        if (!$existingReview) {
            LectureReview::create($data);
            return true; // Review created, return true
        }

        // If review already exists, return false (no change)
        return false;
    }

    /**
     *  Dislike the video (delete review)
     * @return bool
     */
    public function dislikeVideo($lectureId, $studentId): bool
    {
        $review = $this->getReview($lectureId, $studentId);

        // If review exists, delete it and return true
        if ($review) {
            $review->delete();
            return true;
        }

        // If no review was found to delete, return false
        return false;
    }
}
