<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('course_sections', function (Blueprint $table) {
            $table->id(); // id INT AUTO_INCREMENT PRIMARY KEY
            $table->unsignedBigInteger('course_id'); // course_id as UNSIGNED BIGINT

            $table->string('title'); // title as VARCHAR
            $table->text('description')->nullable(); // description as TEXT, nullable

            $table->integer('number'); // number as INT


            $table->boolean('is_active')->default(true); // status as BOOLEAN

            $table->timestamps(); // created_at and updated_at

            // Foreign key constraint
            // $table->foreign('course_id')->references('id')->on('courses');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('course_sections');
    }
};
