<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_tasks', function (Blueprint $table) {
            $table->id(); // id INT AUTO_INCREMENT PRIMARY KEY
            $table->unsignedBigInteger('exam_id'); // exam_id as UNSIGNED BIGINT

            $table->text('question'); // question as TEXT
            $table->json('choices'); // choices as JSON
            $table->text('answer'); // answer as TEXT
            $table->string('image')->nullable(); // image as STRING, nullable
            $table->string('video_time')->nullable(); // video_time as STRING, nullable
            $table->integer('points'); // points as INT

            $table->timestamps(); // created_at and updated_at

            // Foreign key constraint
            $table->foreign('exam_id')->references('id')->on('exams')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_tasks');
    }
};
