<?php

namespace Database\Seeders;

use App\Models\Course;
use App\Models\CourseSection;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CourseSectionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'course_id' => Course::first()?->id,
                'title' => 'مقدمة القدرات',
                'description' => '',
                'is_active' => true,
            ],
            [
                'course_id' => Course::first()?->id,
                'title' => 'الباب الأول: الأعداد والعمليات عليها',
                'description' => '',
                'is_active' => true,
            ],
            [
                'course_id' => Course::first()?->id,
                'title' => 'الباب الثاني :الكسور والعمليات عليها',
                'description' => '',
                'is_active' => true,
            ],
            [
                'course_id' => Course::first()?->id,
                'title' => 'الباب الثالث :الأعداد العشرية والعمليات عليها',
                'description' => '',
                'is_active' => true,
            ],

            [
                'course_id' => Course::first()?->id,
                'title' => 'مقدمة القدرات',
                'description' => '',
                'is_active' => true,
            ],
            [
                'course_id' => Course::first()?->id,
                'title' => 'الباب الأول: الأعداد والعمليات عليها',
                'description' => '',
                'is_active' => true,
            ],
            [
                'course_id' => Course::first()?->id,
                'title' => 'الباب الثاني :الكسور والعمليات عليها',
                'description' => '',
                'is_active' => true,
            ],
            [
                'course_id' => Course::first()?->id,
                'title' => 'الباب الثالث :الأعداد العشرية والعمليات عليها',
                'description' => '',
                'is_active' => true,
            ]
        ];

        CourseSection::each(fn($item) => $item->forceDelete());

        foreach ($data as $i => $item) {
            CourseSection::create([
                'number' => $i + 1,
                ...$item,
            ]);
        }
    }
}
