<?php

namespace Database\Seeders;

use App\Models\Course;
use App\Models\Material;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CourseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'material_id' => Material::first()?->id,
                'title' => 'الكورس الأول',
                'description' => 'ارفع درجاتك مع اختبارات علا الذكية المبنية على امتحانات سابقة وتعالج نقاط ضعفك',
                'number' => 1,
                'is_active' => true,
            ],
            [
                'material_id' => Material::first()?->id,
                'title' => 'الكورس الثاني',
                'description' => 'ارفع درجاتك مع اختبارات علا الذكية المبنية على امتحانات سابقة وتعالج نقاط ضعفك',
                'number' => 2,
                'is_active' => true,
            ]
        ];

        Course::each(fn($item) => $item->forceDelete());

        foreach ($data as $i => $item) {
            Course::create($item);
        }
    }
}
