<?php

namespace Database\Seeders;

use App\Models\Course;
use App\Models\CourseSection;
use App\Models\Lecture;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class LectureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $data = [
            [
                'title'=>'(النسبة المئوية)',
                'description'=>'تابع أقوى المعلمين اللي يشرحون لك كل المواد ويجاوبون أسئلتك ويفهمونك',
            ],[
                'title'=>'(مسائل حياتية: مسائل الأعمار)',
                'description'=>'تابع أقوى المعلمين اللي يشرحون لك كل المواد ويجاوبون أسئلتك ويفهمونك',
            ],[
                'title'=>'(المساحات المظللة)',
                'description'=>'تابع أقوى المعلمين اللي يشرحون لك كل المواد ويجاوبون أسئلتك ويفهمونك',
            ]
        ];

        Lecture::each(fn($item) => $item->forceDelete());

        foreach ($data as $i => $item) {
            Lecture::create([
                'video_id'=> $i + 1,
                'number' => $i + 1,
                'is_active' => true,
                'course_id' => Course::first()?->id,
                'course_section_id'=> CourseSection::inRandomOrder()->first()?->id,
                'teacher_id' => User::where(['name' => 'abdullah-alsubie'])->first()?->id ?? 1,
                'time'=> rand(1,59). '0:00',
                ...$item,
            ]);
        }
    }
}
