<a href="https://www.material-tailwind.com">
    <img width="100%" src="https://www.material-tailwind.com/image/material-tailwind-readme.jpg" alt="material-tailwind" style="border-radius: 24px" />
    <h1 align="center">Material Tailwind</h1>
</a>
</br>
<p align="center">
  <a href="https://www.npmjs.com/package/@material-tailwind/react">
    <img src="https://img.shields.io/npm/dt/@material-tailwind/react.svg" alt="Total Downloads">
  </a>
  <a href="https://github.com/creativetimofficial/material-tailwind/releases">
    <img src="https://img.shields.io/badge/version-2.1.10-blue.svg" alt="Version" />
  </a>
  <a href="https://www.material-tailwind.com/docs/react/license">
    <img src="https://img.shields.io/badge/license-MIT-blue" alt="Licenese">
  </a>
</p>

<br />
<br />

## Documentation

Visit <a href="https://www.material-tailwind.com/docs/react/installation">https://www.material-tailwind.com/docs/react/installation</a> for full documentation.

<br />

## Components

<table>
  <tr>
    <td width="33.3333%">Accordion</td>
    <td width="33.3333%">Alert</td>
    <td width="33.3333%">Avatar</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/accordion">
        <img alt="accordion" src="https://www.material-tailwind.com/image/components/accordion-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/alert">
        <img alt="alert" src="https://www.material-tailwind.com/image/components/alert-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/avatar">
        <img alt="avatar" src="https://www.material-tailwind.com/image/components/avatar-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Badge</td>
    <td width="33.3333%">Breadcrumbs</td>
    <td width="33.3333%">Button</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/badge">
        <img alt="badge" src="https://www.material-tailwind.com/image/components/badge-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/breadcrumbs">
        <img alt="breadcrumbs" src="https://www.material-tailwind.com/image/components/breadcrumbs-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/button">
        <img alt="button" src="https://www.material-tailwind.com/image/components/button-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Button Group</td>
    <td width="33.3333%">Card</td>
    <td width="33.3333%">Checkbox</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/button-group">
        <img alt="button-group" src="https://www.material-tailwind.com/image/components/buttongroup-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/card">
        <img alt="card" src="https://www.material-tailwind.com/image/components/card-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/checkbox">
        <img alt="checkbox" src="https://www.material-tailwind.com/image/components/checkbox-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Chip</td>
    <td width="33.3333%">Collapse</td>
    <td width="33.3333%">Carousel</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/chip">
        <img alt="chip" src="https://www.material-tailwind.com/image/components/chip-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/collapse">
        <img alt="collapse" src="https://www.material-tailwind.com/image/components/collapse-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/carousel">
        <img alt="carousel" src="https://www.material-tailwind.com/image/components/carousel-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Dialog</td>
    <td width="33.3333%">Drawer</td>
    <td width="33.3333%">Icon Button</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/dialog">
        <img alt="dialog" src="https://www.material-tailwind.com/image/components/dialog-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/drawer">
        <img alt="drawer" src="https://www.material-tailwind.com/image/components/drawer-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/icon-button">
        <img alt="icon-button" src="https://www.material-tailwind.com/image/components/icon-button-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Input</td>
    <td width="33.3333%">Form</td>
    <td width="33.3333%">List</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/input">
        <img alt="input" src="https://www.material-tailwind.com/image/components/input-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/form">
        <img alt="form" src="https://www.material-tailwind.com/image/components/form-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/list">
        <img alt="list" src="https://www.material-tailwind.com/image/components/list-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Menu</td>
    <td width="33.3333%">Navbar</td>
    <td width="33.3333%">Popover</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/menu">
        <img alt="menu" src="https://www.material-tailwind.com/image/components/menu-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/navbar">
        <img alt="navbar" src="https://www.material-tailwind.com/image/components/navbar-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/popover">
        <img alt="popover" src="https://www.material-tailwind.com/image/components/popover-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Progress Bar</td>
    <td width="33.3333%">Pagination</td>
    <td width="33.3333%">Radio Button</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/progress-bar">
        <img alt="progress-bar" src="https://www.material-tailwind.com/image/components/progress-bar-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/pagination">
        <img alt="pagination" src="https://www.material-tailwind.com/image/components/pagination-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/radio-button">
        <img alt="radio-button" src="https://www.material-tailwind.com/image/components/radio-button-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Rating Bar</td>
    <td width="33.3333%">Select</td>
    <td width="33.3333%">Slider</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/rating-bar">
        <img alt="rating-bar" src="https://www.material-tailwind.com/image/components/ratingbar-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/select">
        <img alt="select" src="https://www.material-tailwind.com/image/components/select-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/slider">
        <img alt="slider" src="https://www.material-tailwind.com/image/components/slider-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Speed Dial</td>
    <td width="33.3333%">Spinner</td>
    <td width="33.3333%">Stepper</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/speed-dial">
        <img alt="speed-dial" src="https://www.material-tailwind.com/image/components/speeddial-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/spinner">
        <img alt="spinner" src="https://www.material-tailwind.com/image/components/spinner-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/stepper">
        <img alt="stepper" src="https://www.material-tailwind.com/image/components/stepper-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Switch</td>
    <td width="33.3333%">Tabs</td>
    <td width="33.3333%">Text Area</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/switch">
        <img alt="switch" src="https://www.material-tailwind.com/image/components/switch-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/tabs">
        <img alt="tabs" src="https://www.material-tailwind.com/image/components/tabs-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/textarea">
        <img alt="textarea" src="https://www.material-tailwind.com/image/components/text-area-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Timeline</td>
    <td width="33.3333%">Tooltip</td>
    <td width="33.3333%">Typography</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/timeline">
        <img alt="timeline" src="https://www.material-tailwind.com/image/components/timeline-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/tooltip">
        <img alt="tooltip" src="https://www.material-tailwind.com/image/components/tooltip-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/typography">
        <img alt="typography" src="https://www.material-tailwind.com/image/components/typography-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Footer</td>
    <td width="33.3333%">Image</td>
    <td width="33.3333%">Video</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/footer">
        <img alt="footer" src="https://www.material-tailwind.com/image/components/footer-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/img">
        <img alt="img" src="https://www.material-tailwind.com/image/components/img-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/video">
        <img alt="video" src="https://www.material-tailwind.com/image/components/video-thumbnail.jpg">
      </a>
    </td>
  </tr>
  <tr>
    <td width="33.3333%">Sidebar</td>
    <td width="33.3333%">Table</td>
  </tr>
  <tr>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/sidebar">
        <img alt="sidebar" src="https://www.material-tailwind.com/image/components/sidebar-thumbnail.jpg">
      </a>
    </td>
    <td width="33.3333%" style="padding: 0;">
      <a href="https://www.material-tailwind.com/docs/react/table">
        <img alt="table" src="https://www.material-tailwind.com/image/components/table-thumbnail.jpg">
      </a>
    </td>
  </tr>
</table>

<br />

## Getting Started

Learn how to use @material-tailwind/react components to quickly and easily create elegant and flexible pages using Tailwind CSS.

@material-tailwind/react is working with Tailwind CSS classes and you need to have Tailwind CSS installed on your project - <a href="https://tailwindcss.com/docs/installation/framework-guides?ref=material-tailwind" target="_blank">Tailwind CSS Installation.</a>

<br />

1. Intall `@material-tailwind/react`.

```bash
npm i @material-tailwind/react
```

<br />

2. Once you install @material-tailwind/react you need to wrap your tailwind css configurations with the `withMT()` function coming from @material-tailwind/react/utils.

```js
const withMT = require("@material-tailwind/react/utils/withMT");

module.exports = withMT({
  content: ["./src/**/*.{js,jsx,ts,tsx}"],
  theme: {
    extend: {},
  },
  plugins: [],
});
```

<br />

3. @material-tailwind/react comes with a theme provider that set's the default theme/styles for components or to provide your own theme/styles to your components. You need to wrap your entire application with the `ThemeProvider` coming from @material-tailwind/react.

```jsx
import React from "react";
import ReactDOM from "react-dom/client";
import App from "./App";

// @material-tailwind/react
import { ThemeProvider } from "@material-tailwind/react";

const root = ReactDOM.createRoot(document.getElementById("root"));

root.render(
  <React.StrictMode>
    <ThemeProvider>
      <App />
    </ThemeProvider>
  </React.StrictMode>,
);
```

<br />

4. Congratulations 🥳, you did it, now you're ready to use @material-tailwind/react.

```jsx
import { Button } from "@material-tailwind/react";

export default function Example() {
  return <Button>Button</Button>;
}
```

<br />
<br />

## Community

We're excited to see the community adopt Material Tailwind, raise issues, and provide feedback.
Whether it's a feature request, bug report, or a project to showcase, please get involved!

- [Discord](https://discord.com/invite/FhCJCaHdQa)

## Contributing

Contributions are always welcome!

See `CONTRIBUTING.md` for ways to get started.

Please adhere to this project's `CODE_OF_CONDUCT.md`.

## License

[MIT](https://github.com/creativetimofficial/material-tailwind/blob/main/LICENSE)
