import { usePage } from '@inertiajs/react';
import { PublicFooter,  StudentNav } from '../Ui'
import { PropsWithChildren, ReactNode } from 'react';
import { BrandLayoutConfigProps, FooterLayoutConfigProps, Layout, NavLayoutConfigProps } from '../types/models/layout';
import { isEmpty } from '@/Utils';

const StudentLayout = ({
    children,
    withFooter = true,
    withNav = true,
   title=''

}: PropsWithChildren<{ header?: ReactNode, withNav?: boolean, withFooter?: boolean, title?:string }>) => {

    const page = usePage()

    const layout = page.props.layout as Layout[]

    const brand = layout.find(l=>l.field==='brand')?.config as BrandLayoutConfigProps|undefined

    const user = page.props.auth

    const pageLayout = layout.find(l => l.field === 'page_public')?.config

    const bg = !isEmpty(pageLayout?.bg) ? {
        backgroundImage: `url(${pageLayout?.bg})`,
        backgroundSize: 'cover',
        backgroundRepeat: 'no-repeat',
    } : {}

    return (
        <div
            style={{
                color: pageLayout?.color,
                background: pageLayout?.bg_color,
               ...bg,
            }}>
            <div className="">
                {withNav && <StudentNav brand={brand} data={layout.find(l => l.field === 'nav_student')?.config as NavLayoutConfigProps | undefined} />}
                <div className="min-h-screen p-4 md:8 lg:p-16">
                    {children}
                </div>
                {withFooter && <PublicFooter brand={brand} data={layout.find(l => l.field === 'footer_public')?.config as FooterLayoutConfigProps | undefined} />}
            </div>
        </div>
    )
}

export default StudentLayout
