import { FormInput, PrimaryButton } from '@/Components'
import Checkbox from '@/Components/Forms/Checkbox'
import AuthAdminLayout from '@/Layouts/AuthAdminLayout'
import { useForm } from '@inertiajs/react'
import { Link } from 'lucide-react'
import React, { FormEventHandler } from 'react'

type Props = {
    status?: string;
    canResetPassword: boolean;
}

const Login = ({
    status,
    canResetPassword,
}: Props) => {



    const { data, setData, post, processing, errors, reset } = useForm({
        email: '',
        password: '',
        remember: false,
    });

    const submit: FormEventHandler = (e) => {
        e.preventDefault();

        post(route('admin.login'), {
            onFinish: () => reset('password'),
        });
    };


    return (
        <AuthAdminLayout>
            <h1 className='text-center text-2xl mb-10 ' >تسجيل الدخول</h1>
            <form onSubmit={submit} >
                <FormInput
                    label='البريد الإلكتروني'
                    id="email"
                    type="email"
                    name="email"
                    value={data.email}
                    className="mt-1 block w-full"
                    autoComplete="username"
                    error={errors.email}
                    onChange={(e) => setData('email', e.target.value)}
                />
                <FormInput
                    label='كلمة المرور'
                    id="password"
                    type="password"
                    name="password"
                    value={data.password}
                    className="mt-1 block w-full"
                    autoComplete="current-password"
                    onChange={(e) => setData('password', e.target.value)}
                />
                <div className="mt-4 block">
                    <label className="flex items-center">
                        <Checkbox
                            name="remember"
                            checked={data.remember}
                            onChange={(e) =>
                                setData('remember', e.target.checked)
                            }
                        />
                        <span className="ms-2 text-sm text-gray-600">
                           تدكرني
                        </span>
                    </label>
                </div>
                <div className="mt-4 flex items-center justify-end">
                    {canResetPassword && (
                        <Link
                            href={route('password.request')}
                            className="rounded-md text-sm text-gray-600 underline hover:text-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2"
                        >
                            نسيت كلمة المرور
                        </Link>
                    )}

                    <PrimaryButton className="w-full h-[40px] " disabled={processing}>
                    تسجيل
                    </PrimaryButton>
                </div>
            </form>
        </AuthAdminLayout>
    )
}

export default Login
