import { Modal, PrimaryButton } from '@/Components'
import DashboardLayout from '@/Layouts/DashboardLayout'
import SecondaryButton from '@/Trash/Comps/SecondaryButton'
import { ID } from '@/types/models'
import { Course } from '@/types/models/course'
import { CourseNote } from '@/types/models/course-note'
import { ButtonAdd, ButtonDelete, ButtonEdit, CourseNoteForm } from '@/Ui'
import { useForm } from '@inertiajs/react'
import { Card } from 'antd'
import React, { FormEventHandler, useState } from 'react'

type Props = {
    course_notes: CourseNote[],
    courses: Course[]
}

const Notes = ({ course_notes, courses }: Props) => {


    const [modalOpen, setModalOpen] = useState<boolean>(false)
    const [modelSection, setModelSection] = useState('')

    const [selectedCourseNote, setSelectedCourseNote] = useState<CourseNote>()

    const close = () => {
        setModalOpen(false)
        setSelectedCourseNote(undefined)
        setModelSection('')
    }

    const handleAdd = () => {
        setModalOpen(true)
        setSelectedCourseNote(undefined)
        courseNoteForm.setData(defaultCourseNote)
        setModelSection('form')
    }

    const handleDelete = (item: CourseNote) => {
        setSelectedCourseNote(item)
        setModalOpen(true)
        setModelSection('delete')
    }

    const handleEdit = (item: CourseNote) => {
        setSelectedCourseNote(item)
        courseNoteForm.setData(item)
        setModalOpen(true)
        setModelSection('form')
    }

    const defaultCourseNote: CourseNote = {
        id: "",
        course_id: '',
        course_section_id: '',
        type: '',
        content: '',
    }

    const courseNoteForm = useForm(selectedCourseNote ?? defaultCourseNote)

    const createCourseNote: FormEventHandler = (e) => {
        e.preventDefault()
        courseNoteForm.post(route('admin.courseNote.createOne'), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }
    const updateCourseNote: FormEventHandler = (e) => {
        e.preventDefault()
        courseNoteForm.put(route('admin.courseNote.updateOne', selectedCourseNote?.id), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }

    const NoteCard = ({ data }: { data: CourseNote }) => {
        return (<Card className='mb-2'>
            <div className="flex justify-between items-center">
                <div className="">
                    <h4 className='mb-2'> {data.course?.title} </h4>
                    <h5 className='mb-2'> {data.courseSection?.title} </h5>
                </div>
                <div className="flex flex-col gap-2">
                    <ButtonDelete onClick={()=>handleDelete(data)} />
                    <ButtonEdit onClick={()=>handleEdit(data)} />
                </div>
            </div>
        </Card>)
    }


    const DeleteForm = ({ id }: { id: ID }) => {

        const form = useForm()

        const submit: FormEventHandler = (e) => {
            e.preventDefault()
            form.delete(route('admin.courseNote.deleteOne', { id }), {
                onSuccess: () => {
                    close()
                }
            })
        }

        return <div >
            <p className="p-4 ">
                هل تريد حقا حذف هذه المادة!
            </p>
            <div className="mt-5 items-center gap-3 flex ">
                <PrimaryButton className='bg-red-500' onClick={submit} >نعم</PrimaryButton>
                <SecondaryButton onClick={() => close()} >لا</SecondaryButton>
            </div>
        </div>
    }

    return (
        <DashboardLayout title='الملاحظات' headChild={<ButtonAdd onClick={handleAdd} />} >
            <Modal show={modalOpen} onClose={close}>
                {(modelSection === 'delete' && selectedCourseNote) && <DeleteForm id={selectedCourseNote.id} />}
                {modelSection === 'form' && <CourseNoteForm courses={courses} form={courseNoteForm} submit={selectedCourseNote ? updateCourseNote : createCourseNote} />}
            </Modal>
            {course_notes.map((item, i) => <NoteCard data={item} key={i} />)}
        </DashboardLayout>
    )
}

export default Notes
