import { FormInput, PrimaryButton } from '@/Components';
import { useUrlParams } from '@/Hooks';
import PublicLayout from '@/Layouts/PublicLayout';
import { Link, useForm } from '@inertiajs/react';
import { FormEventHandler, useEffect } from 'react';

const Otp = () => {


    const { token } = useUrlParams()

    // Set up the form with useForm hook
    const { data, setData, post, processing, errors } = useForm({
        otp: '',
        token: '',
    });

    useEffect(() => {
        setData('token', token)
    }, [token])

    console.log(token)

    // Handle form submission
    const handleSubmit: FormEventHandler = (e) => {
        e.preventDefault();  // Prevent default form submission

        // Submit the form with OTP and token
        post(route('auth.student.send-otp'), {
            onSuccess: () => {
                // Handle successful submission (e.g., redirect to another page)
            },
            onError: (errors) => {
                // Handle error (e.g., display validation errors)
                console.error(errors);
            }
        });
    };

    return (
        <PublicLayout title='أدخل رمز OTP' withNav={false}>
            <div className="mx-auto flex justify-center mt-20">
                <div className="bg-[#111] rounded-md w-1/3 text-pink-50 p-8 flex flex-col gap-5">
                    <h1 className='text-center text-3xl mb-5 text-pink-50'>تأكيد الرمز</h1>

                    <form onSubmit={handleSubmit}>
                        <FormInput
                            dir='ltr'
                            maxLength={6}
                            label='أدخل رمز OTP'
                            name='otp'
                            placeholder='XXXXXX'
                            className='w-full bg-transparent text-white'
                            value={data.otp}
                            onChange={(e) => setData('otp', e.target.value)}
                            error={errors.otp}
                        />

                        <PrimaryButton className='w-full mt-5' disabled={processing}>
                            {processing ? 'جاري التحقق...' : 'تأكيد'}
                        </PrimaryButton>
                        <div className="mt-2">
                          {token&&  <Link className='text-xs text-center border-b text-gray-400' href={route('auth.student.resend-otp',{token})}>
                                إعادة إرسال الرمز
                            </Link>}
                        </div>
                    </form>
                </div>
            </div>
        </PublicLayout>
    );
}

export default Otp;

