import PublicLayout from '@/Layouts/PublicLayout'
import { PageProps } from '@/types'
import { Legal } from '@/types/models/legal'


const PrivacyPolicy = ({ privacy_policy }: PageProps<{ privacy_policy: Legal[] }>) => {

    return (
        <PublicLayout title='سياسة الخصوصية'>
            <h1 className="mb-20 mt-10 text-4xl text-white text-center font-bold ">سياسة الخصوصية</h1>
            {privacy_policy.map((item,i) => (
                <div className="text-white mb-10 flex flex-col gap-10" key={i}>
                    <strong className='text-3xl font-semibold ' >{item.title} </strong>
                    <p className='mb-10' >{item.content} </p>
                </div>
            ))}
        </PublicLayout>
    )
}

export default PrivacyPolicy
