import { IconLike, IconMessage, IconNotebook, IconSave } from '@/Assets/Svg'
import { FormTextarea, Modal, PrimaryButton } from '@/Components'
import { APP_URL } from '@/Constants'
import StudentLayout from '@/Layouts/StudentLayout'
import { PageProps } from '@/types'
import { ID } from '@/types/models'
import { CourseSection } from '@/types/models/course_section'
import { Lecture, LectureQuestion } from '@/types/models/lecture'
import { Video } from '@/types/models/video'
import { ExamDisplay } from '@/Ui'
import { ensureHttpsUrl } from '@/Utils'
import { Link, useForm } from '@inertiajs/react'
import { FormEventHandler, useEffect, useRef, useState } from 'react'

type Props = {
    course_section: CourseSection
    video_id: ID
    review: boolean

}

const CourseLectures = ({ course_section, video_id, review, auth }: PageProps<Props>) => {

    const [videoPlayed, setVideoPlayed] = useState<Video>()
    const [lectureSelected, setLectureSelected] = useState<Lecture>()
    const [displayContent, setDisplayContent] = useState<'video' | 'exam'>('video')
    const [openModal, setOpenModal] = useState(false)
    const [sectionModal, setSectionModal] = useState('')
    const [currentTime, setCurrentTime] = useState(0);
    const form = useForm()

    const saveForm = useForm({
        student_id: auth.student.id,
        material_id: course_section?.course?.material_id,
        course_id: course_section?.course_id,
        teacher_id: lectureSelected?.teacher_id,
        course_section_id: course_section.id,
        lecture_id: lectureSelected?.id,
        last_watch_time: currentTime,
        is_saved: false,
        is_finishLecture: false,
        is_finishExam: false,
        is_pass_exam: false,
    })

    const handleTimeUpdate = (event: React.SyntheticEvent<HTMLVideoElement>) => {
        const video = event.target as HTMLVideoElement;
        setCurrentTime(video.currentTime); // Update the current time
    };


    const closeModal = () => {
        setOpenModal(false)
        setSectionModal('')
    }


    const getLecture = (id: ID) => {
        return course_section.lectures?.find(v => v.video?.id == id)
    }

    const getVideo = (id: ID) => {
        return getLecture(id)?.video
    }

    console.log('currentTime',currentTime)


    useEffect(() => {

        setLectureSelected(getLecture(video_id))
        setVideoPlayed(getVideo(video_id))

    }, [video_id])


    const reviewLecture = (lectureId: ID) => {
        form.post(route('lecture.' + (review ? 'dislike' : 'like'), { id: lectureId }))
    }

    const handleAsk = () => {
        setOpenModal(true)
        setSectionModal('ask')
    }

    const saveLecture=()=>{

    }


    const Ask = () => {

        const lectureQuestion: LectureQuestion = {
            id: '',
            question: '',
            lecture_id: lectureSelected?.id ?? '',
            student_id: auth.student.id
        }
        const form = useForm(lectureQuestion)

        const submit: FormEventHandler = (e) => {
            e.preventDefault()
            form.post(route('student.lecture.ask'))
        }

        return (
            <form onSubmit={submit}>
                <FormTextarea label='السؤال' value={form.data.question} onChange={e => form.setData('question', e.target.value)} />
                <PrimaryButton className='mt-5' >حفظ</PrimaryButton>
            </form>
        )
    }


    return (
        <StudentLayout title={(lectureSelected?.title ?? course_section.title) ?? ''}>
            <Modal onClose={closeModal} show={openModal} >
                {sectionModal === 'ask' && <Ask />}
            </Modal>
            <div className="flex items-start justify-center gap-5 h-screen flex-wrap">
                {(videoPlayed && displayContent === 'video') && <div className="flex-1">
                    <video onTimeUpdate={handleTimeUpdate} controls className='w-full h-full rounded-2xl ' src={ensureHttpsUrl(videoPlayed.file, APP_URL)}   ></video>
                    <div className="flex justify-between items-center mt-5 gap-3">
                        <h1 className='font-semibold text-xl text-white '>
                            {lectureSelected?.title}
                        </h1>
                        <div className="flex justify-end items-center gap-3">
                            <button onClick={handleAsk} className="bg-slate-800 w-[80px] flex border p-2 text-white border-gray-500 hover:border-purple-500 rounded-md items-center gap-3 cursor-pointer hover:opacity-80">
                                <IconMessage />
                                اسأل
                            </button>
                            <button onClick={() => reviewLecture(video_id)} className="bg-slate-800 w-[80px] flex border p-2 text-white border-gray-500 hover:border-purple-500 rounded-md items-center gap-3 cursor-pointer hover:opacity-80">
                                <IconLike className={!review ? '' : 'text-blue-500'} />
                                قيم
                            </button>
                            <button className="bg-slate-800 w-[80px] flex border p-2 text-white border-gray-500 hover:border-purple-500 rounded-md items-center gap-3 cursor-pointer hover:opacity-80">
                                <IconSave />
                                حفظ
                            </button>
                            <button onClick={() => setDisplayContent('exam')} className="bg-slate-800 w-[150px] justify-center flex border p-2 text-white border-gray-500 hover:border-purple-500 rounded-md items-center gap-3 cursor-pointer hover:opacity-80">
                                <IconNotebook />
                                إمتحن نفسك
                            </button>
                        </div>
                    </div>
                </div>}
                {displayContent === 'exam' && <div className="flex-1">
                    <ExamDisplay exam={course_section.lectures?.find(v => v.video?.id == video_id)?.exam} />
                </div>}
                <div className="flex h-screen  flex-col bg-slate-800 rounded-2xl p-4">
                    <div className="w-[400px]">
                        <h2 className='text-gray-100 text-xl mt-5 mb-10 font-semibold' >
                            {course_section.title}
                        </h2>
                        {course_section.lectures?.map((m, i) => (
                            <div key={i} className="hover:opacity-80 cursor-pointer bg-slate-600 rounded-2xl p-6 text-white mb-3">
                                <Link href={route('student.courseLectures', { id: course_section.course_id, videoId: m.video?.id })} className="  flex justify-start items-start gap-3">
                                    <div className="">
                                        <video className='h-[80px] rounded-xl ' src={ensureHttpsUrl(m.video?.file, APP_URL)} height={400} >
                                        </video>
                                    </div>
                                    <p className='font-semibold max-w-[200px] '>
                                        {m.title}
                                        <br />
                                        <span className='relative text-xs text-gray-300 ' >{m.time} </span>
                                    </p>
                                </Link>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        </StudentLayout>
    )
}

export default CourseLectures
