import { Link, usePage } from '@inertiajs/react'
import { ApplicationLogo, Dropdown } from '../../Components'
import { BrandLayoutConfigProps, NavLayoutConfigProps } from '@/types/models/layout'
import { User } from 'lucide-react'

type Props = {
    data?: NavLayoutConfigProps
    brand?: BrandLayoutConfigProps
}

const PublicNav = ({ data, brand }: Props) => {

    const page = usePage()

    const auth = page.props.auth

    if (!data) {
        return
    }

    return (
        <div className="h-14 flex px-4 py-8 items-center justify-between bg-black " style={{ background: data?.bg_color }}>
            {/* Logo Section */}
            <Link href={route('student.home')} >
                <ApplicationLogo
                    src={brand?.logo.light}
                    height={data?.logo.height}
                    width={data?.logo.width}
                    className={`h-[${data?.logo.height}px] object-contain p-4 `}
                />
            </Link>

            {/* Menu Links */}
            <div className="flex gap-6 items-center">

                <Dropdown >
                    <Dropdown.Trigger>
                        <div className="px-5 flex gap-3 text-white cursor-pointer opacity-80 hover:opacity-100" >
                            <strong className='font-semibold text-xl '>
                                {auth.user.name}
                            </strong>
                            <User />
                        </div>
                    </Dropdown.Trigger>

                    <Dropdown.Content style={{ background: data?.bg_color }}>
                        <Dropdown.Link
                            className='text-white hover:bg-black'
                            href={route('student.profile')}
                        >
                            الملف الشخصي
                        </Dropdown.Link>
                        <Dropdown.Link
                            className='text-white hover:bg-black'
                            href={route('auth.student.logout')}
                            method="post"
                            as="button"
                        >
                            تسجيل الخروج
                        </Dropdown.Link>
                    </Dropdown.Content>
                </Dropdown>

                {data?.menu.map((link, index) => (
                    <a key={index} href={link.href} className="text-white hover:text-gray-100 hover:bg-black p-2">
                        {link.text}
                    </a>
                ))}
            </div>
        </div>
    )
}

export default PublicNav
