import { FormInput, FormUpload, ImageOrUpload, PrimaryButton } from '@/Components'
import { Material } from '@/types/models/material'
import { Divider } from 'antd'
import { FormEventHandler } from 'react'
import LevelSelect from './LevelSelect'
import { SubLevelSelect } from '..'

import { Level } from '@/types/models/level'
import { SubLevel } from '@/types/models/sub_level'
import { useFormProps } from '@/types/app'

type Props = {
    levels: Level[],
    sub_levels: SubLevel[],
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<Material>
}

const MaterialForm = ({ form, levels, sub_levels, submit }: Props) => {
    return (
        <form className='flex flex-col gap-3' onSubmit={submit}>
            <Divider orientation="left" >معلومات المادة</Divider>
            <FormInput label='العنوان' name='title' value={form.data.title} onChange={e => form.setData('title', e.target.value)} error={form.errors.title} />
            <FormInput label='الوصف' name='description' value={form.data.description} onChange={e => form.setData('description', e.target.value)} error={form.errors.description} />
            <LevelSelect levels={levels} selected={form.data.level_id} onSelect={s => form.setData('level_id', s)} />
            <SubLevelSelect levels={sub_levels} selected={form.data.sub_level_id} onSelect={s => form.setData('sub_level', s)} />
            <ImageOrUpload onSuccess={res => {
                form.setData('cover_image', res.file_path)
            }} image={form.data.cover_image} />
            <PrimaryButton className='mt-5' >حفظ</PrimaryButton>
        </form>
    )
}

export default MaterialForm
