import { FormInput, ImageOrUpload, PrimaryButton } from '@/Components'
import { User } from '@/types'
import { useFormProps } from '@/types/app'
import { Teacher } from '@/types/models/teacher'
import React, { FormEventHandler } from 'react'

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<Teacher & User>
}

const TeacherForm = ({ form, submit }: Props) => {
    return (
        <form onSubmit={submit} >
            <FormInput label='الاسم' name='name' value={form.data.name} onChange={e => form.setData('name', e.target.value)} error={form.errors.name} />
            <FormInput label='البريد الالكتروني' name='email' value={form.data.email} onChange={e => form.setData('email', e.target.value)} error={form.errors.email} />
            <FormInput label='رقم الهاتف' name='phone' value={form.data.phone} onChange={e => form.setData('phone', e.target.value)} error={form.errors.phone} />
            <FormInput label='كلمة المرور' name='password' value={form.data.password} onChange={e => form.setData('password', e.target.value)} error={form.errors.password} />
            <FormInput label='الاسم الاول' name='first_name' value={form.data.first_name} onChange={e => form.setData('first_name', e.target.value)} error={form.errors.first_name} />
            <FormInput label='الاسم الاخير' name='last_name' value={form.data.last_name} onChange={e => form.setData('last_name', e.target.value)} error={form.errors.last_name} />
            <FormInput label='السيرة الذاتية' name='bio' value={form.data.bio} onChange={e => form.setData('bio', e.target.value)} error={form.errors.bio} />
            <FormInput label='الوسوم' name='tags' value={form.data.tags?.join(', ')} onChange={e => form.setData('tags', e.target.value.split(',').map(tag => tag.trim()))} error={form.errors.tags} />
            <ImageOrUpload  onSuccess={res=>form.setData('image', res.file_path)}  />
            <PrimaryButton type="submit">حفظ</PrimaryButton>
        </form>
    )

}

export default TeacherForm
