import React from 'react'
import { Space, Table, Tag } from 'antd';
import type { TableProps } from 'antd';
import { Teacher } from '@/types/models/teacher';
import { ButtonDelete, ButtonEdit } from '..';
import moment from 'moment';
import { ensureHttpsUrl } from '@/Utils';
import { APP_URL } from '@/Constants';
import { ID } from '@/types/models';

type Props = {
    teachers: Teacher[]
    onDelete: (item: Teacher) => void
    onEdit: (item: Teacher) => void
}



const TeacherTable = ({ teachers, onDelete, onEdit }: Props) => {

    const columns: TableProps<Teacher>['columns'] = [
        {
            title: '',
            dataIndex: 'image',
            key: 'image',
            render: (text) => <img className='h-20' src={ensureHttpsUrl(text, APP_URL)} />,
        },
        {
            title: 'الإسم',
            dataIndex: 'first_name',
            key: 'first_name',
            render: (text) => <a>{text}</a>,
        },

        {
            title: 'تاريخ الإنشاء',
            dataIndex: 'created_at',
            key: 'created_at',
            render: (text) => <a>{moment(text).format('YYYY-MM-DD')}</a>,
        },
        {
            title: '',
            dataIndex: 'id',
            key: 'id',
            render: (id) => <div className="flex justify-end gap-2">

                <ButtonEdit onClick={() => {
                    const teacher = teachers.find(m => m.id === id)
                    if (teacher) {
                        onEdit(teacher)
                    }
                }} />
                <ButtonDelete onClick={() => {
                    const teacher = teachers.find(m => m.id === id)
                    if (teacher) {
                        onEdit(teacher)
                    }
                }} />
            </div>,
        },
    ]

    return (
        <Table<Teacher> bordered columns={columns} dataSource={teachers} />
    )
}

export default TeacherTable
