import './bootstrap';
import '../css/app.css';

import { createRoot } from 'react-dom/client';
import { createInertiaApp } from '@inertiajs/react';
import { resolvePageComponent } from 'laravel-vite-plugin/inertia-helpers';
import { isEmpty } from './Utils';

const appName = import.meta.env.VITE_APP_NAME || '';

createInertiaApp({
    title: (title) => `${appName} ${!isEmpty(title) ? ` - ${title}`:''}`,
    resolve: (name) => resolvePageComponent(`./Pages/${name}.tsx`, import.meta.glob('./Pages/**/*.tsx')),
    setup({ el, App, props }) {
        const root = createRoot(el);

        root.render(<App {...props} />);
    },
    progress: {
        color: '#ccc',
    },
});
