import { UserTypeEnum } from "@/Enums/UserTypeEnum";
import { Ntf } from "./app";
import { ID } from "./models";
import { Layout } from "./models/layout";
import { Student } from "./models/student";

export interface User {
    id:ID
    name: string;
    first_name: string;
    last_name: string;
    password: string;
    email: string;
    phone: string;
    api_token: string;
    email_verified_at?: string;
    type: UserTypeEnum
    created_at?: string
    updated_at?: string
}

export type PageProps<
    T extends Record<string, unknown> = Record<string, unknown>,
> = T & {
    auth: {
        user: User;
        student: Student
    }
    flash: Ntf
    layout: Layout[]
};
