import { Exam } from './exam';
import { ID, Model } from './index';
import { Teacher } from './teacher';
import { Video } from './video';

export type Lecture = Model &{
    course_id:ID
    course_section_id:ID
    teacher_id:ID
    video_id:ID
    title:string
    description:string
    time:string
    number:number
    is_active:boolean

    teacher?:Teacher
    video?:Video
    exam?:Exam
  };


  export type LectureQuestion = Model & {
      lecture_id: ID; // Foreign key referencing the lecture
      student_id: ID; // Foreign key referencing the student
      question: string; // The question content
      answer?: string | null; // The answer, optional and nullable
  };

  export type LectureReview = Model & {
    student_id: ID; // Foreign key referencing the student
    lecture_id: ID; // Foreign key referencing the lecture
};
