<?php

use App\Http\Controllers\RestApi\V1\AdminController;
use App\Http\Controllers\RestApi\V1\AuthController;
use App\Http\Controllers\RestApi\V1\LectureController;
use App\Http\Controllers\RestApi\V1\LectureQuestionController;
use App\Http\Controllers\RestApi\V1\MaterialNoteController;
use App\Http\Controllers\RestApi\V1\PermissionController;
use App\Http\Controllers\RestApi\V1\PublicController;
use App\Http\Controllers\RestApi\V1\RoleController;
use App\Http\Controllers\RestApi\V1\StudentController;
use App\Http\Controllers\RestApi\V1\StudentProcessCourseController;
use App\Http\Controllers\RestApi\V1\UserController;
use App\Http\Middleware\RestApi\AdminMiddleware;
use App\Http\Middleware\RestApi\DashboardMiddleware;
use App\Http\Middleware\RestApi\StudentMiddleware;
use App\Http\Middleware\RestApi\SuperAdminMiddleware;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RestApi\V1\CourseController;
use App\Http\Controllers\RestApi\V1\CourseNoteController;
use App\Http\Controllers\RestApi\V1\CourseSectionController;
use App\Http\Controllers\RestApi\V1\ExamController;
use App\Http\Controllers\RestApi\V1\ExamTaskController;
use App\Http\Controllers\RestApi\V1\LevelController;
use App\Http\Controllers\RestApi\V1\MaterialController;
use App\Http\Controllers\RestApi\V1\SubLevelController;
use App\Http\Controllers\RestApi\V1\TeacherController;
use App\Http\Controllers\RestApi\V1\UploadController;
use App\Http\Controllers\RestApi\V1\VideoController;


Route::prefix('auth')->controller(AuthController::class)->group(function () {

    // Guest
    Route::middleware('guest')->group(function () {

        Route::prefix('student')->group(function () {
            Route::post('/login/', 'loginPhone');
            Route::post('/register', 'registerStudent');
        });
        Route::prefix('admin')->group(function () {
            Route::post('/login/', 'login');
        });
        Route::prefix('teacher')->group(function () {
            Route::post('/login/', 'loginPhone');
        });
        Route::post('/verify-otp', 'verifyOtp');
        Route::get('/validate-token', 'validateTokenMethod');
    });
    // Auth
    Route::middleware('auth:sanctum')->group(function () {
        Route::put('/password/update', 'updatePassword');
        Route::post('/logout', 'logout');
        Route::post('/verify-email', 'verifyEmail');
        Route::post('/verify-notification-sent', 'emailVerificationNotification');

        Route::post('/tokens/create', function (Request $request) {
            $token = $request->user()->createToken($request->token_name);

            return ['token' => $token->plainTextToken];
        });
    });


});

Route::middleware(['auth:sanctum', DashboardMiddleware::class])->group(function () {

    Route::post('/upload/{type}', [UploadController::class, 'handleUpload']);

    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    Route::prefix('admins')->controller(AdminController::class)->middleware(SuperAdminMiddleware::class)->group(function () {
        Route::get('/', 'read');
        Route::get('/{id}', 'readOne');
        Route::post('/create', 'createOne');
        Route::put('/update/{id}', 'updateOne');
        Route::delete('/delete/{id}', 'deleteOne');
    });

    Route::prefix('materials')->controller(MaterialController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('exams')->controller(ExamController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'create');
            Route::put('/update/{id}', 'update');
            Route::delete('/delete/{id}', 'delete');
        });

    Route::prefix('exam-tasks')->controller(ExamTaskController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('levels')->controller(LevelController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('sub-levels')->controller(SubLevelController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('courses')->controller(CourseController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('course-sections')->controller(CourseSectionController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('course-notes')->controller(CourseNoteController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('material-notes')->controller(MaterialNoteController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('lectures')->controller(LectureController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::prefix('videos')->controller(VideoController::class)
        ->group(function () {
            Route::get('/', 'read');
            Route::get('/{id}', 'readOne');
            Route::post('/create', 'createOne');
            Route::put('/update/{id}', 'updateOne');
            Route::delete('/delete/{id}', 'deleteOne');
        });

    Route::middleware(AdminMiddleware::class)->group(function () {

        Route::prefix('teachers')->controller(TeacherController::class)
            ->group(function () {
                Route::get('/', 'read');
                Route::get('/{id}', 'readOne');
                Route::post('/create', 'createOne');
                Route::put('/update/{id}', 'updateOne');
                Route::delete('/delete/{id}', 'deleteOne');
            });
        Route::prefix('users')->controller(UserController::class)
            ->group(function () {
                Route::get('/', 'read');
                Route::get('/{id}', 'readOne');
                Route::post('/create', 'createOne');
                Route::put('/update/{id}', 'updateOne');
                Route::delete('/delete/{id}', 'deleteOne');
            });
        Route::prefix('roles')->controller(RoleController::class)
            ->group(function () {
                Route::get('/', 'read');
                Route::get('/{id}', 'readOne');
                Route::post('/create', 'createOne');
                Route::put('/update/{id}', 'updateOne');
                Route::delete('/delete/{id}', 'deleteOne');
                Route::delete('/delete/{id}', 'deleteOne');
                Route::post('/assign-role/{roleId}/{permissionId}', 'assignRole');
            });
        Route::prefix('permissions')->controller(PermissionController::class)
            ->group(function () {
                Route::get('/', 'read');
                Route::get('/{id}', 'readOne');
                Route::post('/create', 'createOne');
                Route::put('/update/{id}', 'updateOne');
                Route::delete('/delete/{id}', 'deleteOne');
                Route::post('/give-permission-to/{roleId}/{permissionId}', 'givePermissionTo');

            });
    });




});

Route::controller(PublicController::class)->group(function () {


    Route::get('settings', 'settings');
    Route::get('layout', 'layout');
    Route::get('terms-conditions', 'termsAndConditions');
    Route::get('privacy-policies', 'privacyPolicies');

});

Route::prefix('student')->middleware(['auth:sanctum', StudentMiddleware::class])->group(function () {
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
    Route::controller(StudentController::class)->group(function () { {
            Route::post('/add-level/{id}', 'addLevel');
        }
    });
    Route::controller(LectureController::class)->group(function () { {
            Route::post('/lecture/like/{id}', 'like');
            Route::post('/lecture/dislike/{id}', 'dislike');
        }
    });
    Route::controller(LectureQuestionController::class)->group(function () { {
            Route::post('/ask', 'createOne');
        }
    });
    Route::prefix('student-process-courses')->controller(StudentProcessCourseController::class)->group(function () { {
            Route::post('/', 'readByStudent');
            Route::post('/save', 'saveByStudent');
        }
    });
});

