<?php

use App\Http\Controllers\Auth\AuthStudentController;
use App\Http\Middleware\View\StudentMiddleware;
use Illuminate\Support\Facades\Route;

Route::controller(AuthStudentController::class)
    ->prefix('student/auth')
    ->group(function () {

        Route::post('/login', 'login')->name('auth.student.login');
        Route::post('/logout', 'logout')->name('auth.student.logout');
        Route::post('/register', 'register')->name('auth.student.register');
        Route::post('/send-otp', 'sendOtp')->name('auth.student.send-otp');
        Route::get('/resend-otp/{token}', 'resendOtp')->name('auth.student.resend-otp');


        Route::middleware(['auth', StudentMiddleware::class])->group(function () {
            Route::post('/changePhone', 'changePhone')->name('auth.student.changePhone');
        });
    });
