<?php

use Illuminate\Support\Facades\Route;

if (!function_exists('makeCrudRoute')) {

    function makeCrudRoute(string $commonRoute, string $controller, ?Closure $moreRoutes = null): void
    {
        $pluralRoute = \Str::plural($commonRoute);

        Route::controller($controller)->group(function () use ($commonRoute, $pluralRoute, $moreRoutes) {
            // additional routes
            if ($moreRoutes) {
                $moreRoutes($commonRoute, $pluralRoute);
            }

            // read
            Route::get($pluralRoute, 'index');
            Route::get($pluralRoute . '/paging', 'readPaging');
            Route::get($commonRoute . '/{id}', 'show');

            // create
            Route::post($commonRoute, 'store');

            // update
            Route::put($commonRoute . '/{id}', 'update');
            Route::put($pluralRoute, 'updateAll');

            // delete
            Route::delete($commonRoute . '/{id}', 'destroy');
            Route::delete($pluralRoute, 'deleteAll');
            Route::delete($pluralRoute . '/truncate', 'empty');

            // search
            Route::get($pluralRoute . '/search', 'search');
        });
    }
}
