<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\Course\CreateCourseRequest;
use App\Http\Requests\Course\UpdateCourseRequest;
use Illuminate\Http\Request;

class CourseController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateCourseRequest $request)
    {
        if ($this->create($request, [
            'number' => $this->model::count() + 1,
            'is_active' => true,
        ])) {
            return $this->redirectWithNotification(
                redirect()->route('admin.materials.detail', ['id' => $request->material_id]),
                'success',
                'Course created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create course');
    }

    public function updateOne(UpdateCourseRequest $request, $id)
    {
        if ($this->update($request, $id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.materials.detail', ['id' => $request->material_id]),
                'success',
                'Course updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update course');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->redirectWithNotification(
                back(),
                'success',
                'Course deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete course');
    }
}
