<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\Lecture\CreateLectureRequest;
use App\Http\Requests\Lecture\UpdateLectureRequest;
use App\Services\Model\LectureService;
use App\Services\Model\StudentService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LectureController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct(
        protected ?StudentService $studentService,
        protected LectureService $lectureService,
    ) {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateLectureRequest $request)
    {
        if($this->create($request)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.lecture'), 'success', 'Lecture created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create exam');
    }

    public function updateOne(UpdateLectureRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.lecture'), 'success', 'Lecture updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update exam');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.lecture'), 'success', 'Lecture deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete exam');
    }

    public function like($id)
    {
        $result = $this->lectureService->likeVideo($id,$this->studentService->student()->id );

        return $this->redirectWithNotification(
            back(),
            $result ? 'video liked' : 'failed to like video',
            $result ? 'success' : 'error'
        );
    }
    public function dislike($id)
    {
        $result = $this->lectureService->dislikeVideo($id,$this->studentService->student()->id );

        return $this->redirectWithNotification(
            back(),
            $result ? 'video disliked' : 'failed to dislike video',
            $result ? 'success' : 'error'
        );
    }
}
