<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\LectureQuestion\CreateLectureQuestionRequest;
use App\Http\Requests\LectureQuestion\UpdateLectureQuestionRequest;
use Illuminate\Http\Request;

class LectureQuestionController extends CoreController
{

    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateLectureQuestionRequest $request)
    {
        if($this->create($request,['answer'=>null])) {
            return $this->redirectWithNotification(
                redirect()->route('admin.lecture-questions'), 'success', 'Lecture question created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create lecture question');
    }

    public function updateOne(UpdateLectureQuestionRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.lecture-questions'), 'success', 'Lecture question updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update lecture question');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
                redirect()->route('admin.lecture-questions'), 'success', 'Lecture question deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete lecture question');
    }
}
