<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\ModelGetExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\RestApiController;
use App\Http\Requests\StudentProcessCourse\CreateStudentProcessCourseRequest;
use App\Http\Requests\StudentProcessCourse\UpdateStudentProcessCourseRequest;
use Request;


class StudentProcessCourseController extends RestApiController
{

    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: [
            'subStudentProcessCourses',
            'materials',
            'students',
        ])->get());
    }

    public function readOne($id)
    {
        return $this->successResponse($this->model::with(relations: [

        ])->findOrFail($id));
    }

    public function readByStudent()
    {
        return $this->successResponse($this->model::with(relations: [

        ])->where(
            'student_id',auth()->id()
        )->get());
    }

    public function createOne(CreateStudentProcessCourseRequest $request)
    {
        if ($this->create($request)) {
            return $this->successResponse(
                $this->modelCreated,
                'StudentProcessCourse created successfully',
                201
            );
        }

        return $this->badRequestResponse('Failed to create StudentProcessCourse');
    }

    public function updateOne(UpdateStudentProcessCourseRequest $request, $id)
    {
        if ($this->update($request, $id)) {
            return $this->successResponse(
                $this->modelUpdated,
                'StudentProcessCourse updated successfully'
            );
        }

        return $this->badRequestResponse('Failed to update StudentProcessCourse');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->successResponse(
                null,
                'StudentProcessCourse deleted successfully'
            );
        }

        return $this->badRequestResponse('Failed to delete StudentProcessCourse');
    }

    public function saveByStudent(CreateStudentProcessCourseRequest $request)
    {
        $validatedData = $request->validated();
        $attributes = [];
        if (isset($validatedData['id'])) {
            $attributes['id'] = $validatedData['id'];
        }

        if (
            $this->updateOrCreate($request, [
                'student_id' => auth()->id(),
                'last_watch_time' => '00:00',
                'is_saved' => false,
                'is_finishLecture' => false,
                'is_finishExam' => false,
                'is_pass_exam' => false,
            ], $attributes)
        ) {
            return $this->successResponse(
                $this->modelCreated,
                'StudentProcessCourse saved successfully',
                201
            );
        }

        return $this->badRequestResponse('Failed to save StudentProcessCourse');
    }
}
