<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class UploadController extends Controller
{
    public function doc(Request $request)
    {
        return $this->uploadFile($request, '/uploads/docs/', "docs", "docs");
    }

    public function audio(Request $request)
    {
        return $this->uploadFile($request, "/uploads/audios/", "audio", "audios");
    }

    public function video(Request $request)
    {
        return $this->uploadFile($request, '/uploads/videos/', "video", "videos");
    }

    public function pic(Request $request)
    {
        return $this->uploadFile($request, '/uploads/images/', "image", "images");
    }

    private function uploadFile(Request $request, $path, $type, $location)
    {
        $file = $request->file('file');

        if ($file->isValid()) {
            $fileName = sprintf('%s-%s-%s', time(), uniqid(), $file->getClientOriginalName());
            $file->move(public_path($path), $fileName);

            $ex = pathinfo($fileName, PATHINFO_EXTENSION);
            $filePath = public_path($path . $fileName);

            // Check if the file is a JSON file and read its content
            $data = [];
            if ($ex === 'json') {
                $jsonContent = file_get_contents($filePath);
                $data = json_decode($jsonContent, true);
            }

            return response()->json([
                'success' => true,
                'file_path' => $path . $fileName,
                'file' => $fileName,
                'name' => pathinfo($file->getClientOriginalName(), PATHINFO_BASENAME),
                'type' => $type,
                'extension' => $ex,
                'data' => $data, // Include the JSON content if available
            ], Response::HTTP_CREATED);
        }

        return response()->json([
            'message' => 'Upload file failed'
        ], Response::HTTP_BAD_REQUEST);
    }

    public function handleUpload(Request $request, $type)
    {
        return match ($type) {
            'image' => $this->pic($request),
            'video' => $this->video($request),
            'audio' => $this->audio($request),
            'doc' => $this->doc($request),
        };
    }
}
