<?php

namespace App\Http\Controllers\View;

use App\Http\Controllers\Controller;
use App\Models\Course;
use App\Models\CourseNote;
use App\Models\Exam;
use App\Models\Layout;
use App\Models\Lecture;
use App\Models\Level;
use App\Models\Material;
use App\Models\Permission;
use App\Models\Role;
use App\Models\Setting;
use App\Models\SubLevel;
use App\Models\Teacher;
use App\Models\User;
use App\Models\Video;
use App\Services\Model\LectureService;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Yaza\LaravelGoogleDriveStorage\Gdrive;

class DashboardController extends Controller
{
    public function __construct(
        protected ?LectureService $lectureService,
    ) {
    }

    public function dashboard(Request $request)
    {
        return Inertia::render('Dashboard/Home', []);
    }

    public function settings(Request $request)
    {

        return Inertia::render('Dashboard/Settings', [
            'settings' => Setting::all()
        ]);
    }
    public function layout(Request $request)
    {
        return Inertia::render('Dashboard/Layout', [
            'layouts' => Layout::all()
        ]);
    }
    public function materials(Request $request)
    {
        return Inertia::render('Dashboard/Materials', [
            'levels' => Level::all(),
            'sub_levels' => SubLevel::all(),
            'materials' => Material::with(['level', 'subLevel'])->get(),

        ]);
    }
    public function materialDetails(Request $request, $id)
    {
        return Inertia::render('Dashboard/MaterialDetails', [
            'videos' => Video::all(),
            'teachers' => Teacher::with('user')->get(),
            'levels' => Level::all(),
            'sub_levels' => SubLevel::all(),
            'material' => Material::with([
                'courses.sections.lectures',
                'level',
                'subLevel'
            ])->findOrFail($id)
        ]);
    }
    public function exams(Request $request)
    {
        return Inertia::render('Dashboard/Exams', [
            "exams" => Exam::with(['tasks', 'lecture'])->get(),
            'lectures' => Lecture::all()
        ]);
    }
    public function examDetail(Request $request, $id)
    {
        return Inertia::render('Dashboard/ExamDetails', [
            "exam" => Exam::with(['tasks', 'lecture'])->findOrFail($id),
            'lectures' => Lecture::all()
        ]);
    }
    public function notes(Request $request)
    {
        return Inertia::render('Dashboard/Notes', [
            'course_notes' => CourseNote::with('course.sections', 'courseSection')->get(),
            'courses' => Course::with('sections')->get(),
        ]);
    }
    public function noteDetail(Request $request, $id)
    {
        return Inertia::render('Dashboard/NoteDetail', [
            "course_note" => CourseNote::findOrFail($id),
            'courses' => Course::with('sections')->get(),
        ]);
    }
    public function users(Request $request)
    {
        return Inertia::render('Dashboard/Users', [
            'users' => User::all()
        ]);
    }
    public function teachers(Request $request)
    {
        return Inertia::render('Dashboard/Teachers', [
            'teachers' => Teacher::with('user')->get()
        ]);
    }

    public function levels(Request $request)
    {
        return Inertia::render('Dashboard/Levels', [
            'levels' => Level::with('subLevels')->get(),
        ]);
    }

    public function videos(Request $request)
    {
        return Inertia::render('Dashboard/Videos', [
            'videos' => Video::all(),
        ]);
    }

    public function roles(Request $request)
    {

        return Inertia::render('Dashboard/Roles', [
            'roles' => Role::with('permissions')->get(),

            'permissions' => Permission::with('roles')->get(),
        ]);
    }
    public function permissions(Request $request)
    {
        return Inertia::render('Dashboard/Permissions', [
            'permissions' => Permission::with('roles')->get(),
            'roles' => Role::with('permissions')->get(),

        ]);
    }
}
