<?php

namespace App\Http\Controllers\View;

use App\Http\Controllers\Controller;
use App\Models\CourseNote;
use App\Models\CourseSection;
use App\Models\Level;
use App\Models\Material;
use App\Models\MaterialNote;
use App\Services\Api\CountryApi;
use App\Services\Model\LectureService;
use App\Services\Model\StudentService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class StudentController extends Controller
{
    public function __construct(
        protected ?StudentService $studentService,
        protected ?LectureService $lectureService,
    ) {
    }

    public function home(Request $request)
    {
        $props = [];

        if (!$this->studentService?->student()?->level) {
            $props['levels'] = Level::with(['subLevels', 'materials'])->get();
        }

        return Inertia::render('Student/Home', [
            ...$props
        ]);
    }

    public function profile(Request $request)
    {
        return Inertia::render('Student/Profile', [
            'levels'=>Level::with(['subLevels'])->get()

        ]);
    }
    public function material(Request $request, $id)
    {
        return Inertia::render('Student/Material', [
            'material' => Material::with(['courses.sections.lectures',])->findOrFail($id),
        ]);
    }

    public function materialNotes(Request $request, $materialId)
    {
        return Inertia::render('Student/MaterialNote', [
            'notes' => MaterialNote::where(['material_id' => $materialId])->get()
        ]);
    }
    public function materialNotesDetail(Request $request, $id)
    {
        return Inertia::render('Student/MaterialNoteDetail', [
            'note' => MaterialNote::findOrFail($id)
        ]);
    }

    public function courseLectures(Request $request, $id, $videoId)
    {
        // Find the course section with its related lectures and videos
        $course_section = CourseSection::with(['lectures.video', 'lectures.exam.tasks'])->findOrFail($id);

        // Find the specific lecture that matches the videoId
        $lecture = $course_section->lectures->firstWhere('video.id', $videoId);

        if (!$lecture) {
            // Handle the case where the lecture with the given videoId is not found
            abort(404, 'Lecture not found.');
        }

        // Fetch the review (true if exists, false if not)
        $review = (bool) $this->lectureService->getReview(
            lectureId: $lecture->id,
            studentId: $this->studentService->student()->id
        );


        // Return the Inertia view with the necessary data
        return Inertia::render('Student/CourseLectures', [
            'course_section' => $course_section,
            'video_id' => $videoId,
            'review' => $review
        ]);
    }


    public function allExams(Request $request, $id)
    {
    }
    public function exam(Request $request, $id)
    {
    }
}
