<?php

namespace App\Http\Requests\Lecture;

use Illuminate\Foundation\Http\FormRequest;

class CreateLectureRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'course_id' => 'required|numeric,exists:courses,id',
            'course_section_id' => 'required|numeric,exists:course_sections,id',
            'teacher_id' => 'required|numeric,exists:teachers,id',
            'video_id' => 'required|numeric,exists:videos,id',
            'title' => 'required|string',
            'description' => 'required|string',
            'time' => 'required|string',
            'number' => 'nullable|integer',
            'is_active' => 'nullable|boolean'
        ];
    }
}
