<?php

namespace App\Http\Requests\StudentProcessCourse;

use Illuminate\Foundation\Http\FormRequest;

class CreateStudentProcessCourseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'student_id'=>'required|exists:students,id',
            'material_id'=>'required|exists:materials,id',
            'course_id'=>'required|exists:courses,id',
            'teacher_id'=>'required|exists:teachers,id',
            'course_section_id'=>'required|exists:course_sections,id',
            'lecture_id'=>'required|exists:lectures,id',
            'last_watch_time'=>'nullable|string',
            'is_saved'=>'nullable|boolean',
            'is_finishLecture'=>'nullable|boolean',
            'is_finishExam'=>'nullable|boolean',
            'is_pass_exam'=>'nullable|boolean',
        ];
    }
}
