<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Material extends Model
{
    /** @use HasFactory<\Database\Factories\MaterialFactory> */
    use HasFactory;



    protected $fillable = [
        'title',
        'description',
        'cover_image',
        'level_id',
        'sub_level_id',
    ];

    protected $casts = [
        'title' => 'string',
        'description' => 'string', // Nullable, so it's treated as a string if present
        'cover_image' => 'string',
        'level_id' => 'integer',
        'sub_level_id' => 'integer',
    ];

    public function level()
    {
        return $this->belongsTo(Level::class);
    }

    public function subLevel()
    {
        return $this->belongsTo(SubLevel::class);
    }

    public function courses()
    {
        return $this->hasMany(Course::class);
    }

    public function notes()
    {
        return $this->hasMany(MaterialNote::class);
    }
}
